#include <p30fxxxx.h>
#include <timer.h>

/*******************************************************************
*    Function Name: ConfigIntTimer23                               *
*    Description:   This Function Configures Interrupt and sets    *
*                   Interrupt Priority                             *
*    Parameters:    unsigned int config                            *
*    Return Value:  None                                           *
*******************************************************************/

void ConfigIntTimer23(unsigned int config)
{
    IFS0bits.T3IF = 0;                   /* clear IF bit */
    IPC1bits.T3IP = (config &0x0007);    /* assigning Interrupt Priority */
    IEC0bits.T3IE = (config &0x0008)>>3; /* Interrupt Enable /Disable */
}
